/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.polymorph.common.integration.extendedcrafting;

import com.blakebr0.extendedcrafting.api.crafting.ITableRecipe;
import com.blakebr0.extendedcrafting.client.screen.BasicAutoTableScreen;
import com.blakebr0.extendedcrafting.container.BasicAutoTableContainer;
import com.blakebr0.extendedcrafting.container.BasicTableContainer;
import com.blakebr0.extendedcrafting.container.inventory.ExtendedCraftingInventory;
import com.blakebr0.extendedcrafting.tileentity.AutoTableTileEntity;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.block.entity.BlockEntity;
import top.theillusivec4.polymorph.api.PolymorphApi;
import top.theillusivec4.polymorph.api.client.base.IPolymorphClient;
import top.theillusivec4.polymorph.api.common.base.IPolymorphCommon;
import top.theillusivec4.polymorph.common.integration.AbstractCompatibilityModule;
import top.theillusivec4.polymorph.common.integration.extendedcrafting.AutoTableRecipeData;
import top.theillusivec4.polymorph.common.integration.extendedcrafting.AutoTableRecipesWidget;
import top.theillusivec4.polymorph.mixin.integration.extendedcrafting.AccessorAutoTableContainer;
import top.theillusivec4.polymorph.mixin.integration.extendedcrafting.AccessorAutoTableTileEntity;

public class ExtendedCraftingModule
extends AbstractCompatibilityModule {
    private static final AbstractContainerMenu EMPTY_CONTAINER = new AbstractContainerMenu(null, -1){

        public boolean m_6875_(@Nonnull Player player) {
            return false;
        }
    };

    @Override
    public void setup() {
        IPolymorphCommon commonApi = PolymorphApi.common();
        commonApi.registerTileEntity2RecipeData(tileEntity -> {
            if (tileEntity instanceof AutoTableTileEntity.Basic) {
                AutoTableTileEntity.Basic tableTile = (AutoTableTileEntity.Basic)tileEntity;
                return new AutoTableRecipeData((AutoTableTileEntity)tableTile);
            }
            return null;
        });
        commonApi.registerContainer2TileEntity(container -> {
            if (container instanceof BasicAutoTableContainer) {
                BasicAutoTableContainer table = (BasicAutoTableContainer)container;
                AccessorAutoTableContainer access = (AccessorAutoTableContainer)table;
                return access.getWorld().m_7702_(access.getPos());
            }
            return null;
        });
    }

    @Override
    public void clientSetup() {
        IPolymorphClient clientApi = PolymorphApi.client();
        clientApi.registerWidget(containerScreen -> {
            if (containerScreen instanceof BasicAutoTableScreen && containerScreen.m_6262_() instanceof BasicAutoTableContainer) {
                return clientApi.findCraftingResultSlot(containerScreen).map(slot -> new AutoTableRecipesWidget((AbstractContainerScreen<?>)containerScreen, (Slot)slot)).orElse(null);
            }
            return null;
        });
    }

    @Override
    public boolean openContainer(AbstractContainerMenu container, ServerPlayer serverPlayerEntity) {
        if (container instanceof BasicTableContainer) {
            BasicTableContainer table = (BasicTableContainer)container;
            PolymorphApi.common().getRecipeData((Player)serverPlayerEntity).ifPresent(recipeData -> {
                ExtendedCraftingInventory inv = ExtendedCraftingModule.getMatrix((AbstractContainerMenu)table);
                if (inv != null) {
                    container.m_6199_((Container)inv);
                }
            });
            return true;
        }
        return false;
    }

    @Override
    public boolean selectRecipe(AbstractContainerMenu container, Recipe<?> recipe) {
        if (container instanceof BasicTableContainer || container instanceof BasicAutoTableContainer) {
            ExtendedCraftingInventory inv = ExtendedCraftingModule.getMatrix(container);
            if (inv != null) {
                container.m_6199_((Container)inv);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean selectRecipe(BlockEntity tileEntity, Recipe<?> recipe) {
        if (tileEntity instanceof AutoTableTileEntity.Basic) {
            AutoTableTileEntity.Basic basic = (AutoTableTileEntity.Basic)tileEntity;
            AutoTableTileEntity.WrappedRecipe wrappedRecipe = null;
            if (recipe instanceof ITableRecipe) {
                ITableRecipe tableRecipe = (ITableRecipe)recipe;
                wrappedRecipe = new AutoTableTileEntity.WrappedRecipe(tableRecipe);
            } else if (recipe instanceof CraftingRecipe) {
                CraftingRecipe craftingRecipe = (CraftingRecipe)recipe;
                ExtendedCraftingInventory craftingInventory = new ExtendedCraftingInventory(EMPTY_CONTAINER, basic.getRecipeInventory(), 3);
                wrappedRecipe = new AutoTableTileEntity.WrappedRecipe(craftingRecipe, (CraftingContainer)craftingInventory);
            }
            if (wrappedRecipe != null) {
                ((AccessorAutoTableTileEntity)basic).setRecipe(wrappedRecipe);
                PolymorphApi.common().getPacketDistributor().sendBlockEntitySyncS2C(basic.m_58899_(), recipe.m_6423_());
            }
        }
        return false;
    }

    private static ExtendedCraftingInventory getMatrix(AbstractContainerMenu container) {
        for (Slot slot : container.f_38839_) {
            Container container2 = slot.f_40218_;
            if (!(container2 instanceof ExtendedCraftingInventory)) continue;
            ExtendedCraftingInventory inv = (ExtendedCraftingInventory)container2;
            return inv;
        }
        return null;
    }
}

